/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.command;

import com.ibm.hsc.client.PICECDataBean;
import com.ibm.hsc.client.PIHSCCECClient;
import com.ibm.hsc.client.PIHSCClientObjectFactory;
import com.ibm.hsc.client.PIHSCFrameClient;
import com.ibm.hsc.client.PIHSCSysClient;
import com.ibm.hsc.command.PIHMCCommandUtils;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.exceptions.PIHscClientException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;

public class PIDumpCommand {
    private static final int NUM_VALID_PARMS = 4;
    private String m_managedSystem;
    private String m_frame;
    private String m_side;
    private String m_dumpType;
    private HashMap m_validParms = new HashMap(9, 0.5f);
    private static final String TYPE_SYSTEM = "sys";
    private static final String TYPE_FSP = "sp";
    private static final String TYPE_SMA = "sma";
    private static final String TYPE_POWER_SUBSYSTEM = "pss";
    private PIHSCCECClient m_CECClient = null;
    private PIHSCFrameClient m_FrameClient = null;
    private PrintStream m_out;
    private boolean m_writeStatus;

    private PIDumpCommand(PIHSCFrameClient pIHSCFrameClient, PIHSCCECClient pIHSCCECClient, PrintStream printStream, boolean bl) {
        this.m_CECClient = pIHSCCECClient;
        this.m_FrameClient = pIHSCFrameClient;
        this.m_out = printStream;
        this.m_writeStatus = bl;
        this.m_validParms.put("-m", null);
        this.m_validParms.put("-t", null);
        this.m_validParms.put("-e", null);
        this.m_validParms.put("-s", null);
    }

    private PIHSCSysClient createSysClient() throws PIHscClientException {
        String string = "";
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        PIHSCClientObjectFactory pIHSCClientObjectFactory = PIHSCClientObjectFactory.getInstance(string, null);
        PIHSCSysClient pIHSCSysClient = null;
        if (this.m_CECClient != null) {
            pIHSCSysClient = pIHSCClientObjectFactory.createSysClient(this.m_managedSystem, false, 0);
        } else if (this.m_FrameClient != null) {
            pIHSCSysClient = pIHSCClientObjectFactory.createSysClient(this.m_frame, false, 1);
        }
        if (null == pIHSCSysClient) {
            if (this.m_CECClient == null) {
                throw new PIHscClientException("8000", "HSCExceptionBundle", "8002", null, null);
            }
            if (this.m_FrameClient == null) {
                throw new PIHscClientException("8000", "HSCExceptionBundle", "8001", null, null);
            }
            return null;
        }
        return pIHSCSysClient;
    }

    private void doGetDump() throws PIHscClientException {
        String string = "";
        String string2 = "PRIMARY";
        PIHSCSysClient pIHSCSysClient = this.createSysClient();
        if (pIHSCSysClient != null) {
            if (this.m_frame != null && "a".equals(this.m_side)) {
                string2 = "SIDE_A";
            } else if (this.m_frame != null && "b".equals(this.m_side)) {
                string2 = "SIDE_B";
            }
            string = pIHSCSysClient.getDump(this.m_dumpType, string2);
        }
        if (this.m_writeStatus) {
            this.m_out.print('\u0000');
            this.m_writeStatus = false;
        }
        this.m_out.println(string);
    }

    private void performCommand() throws PIHscClientException {
        PICECDataBean pICECDataBean;
        int n;
        this.checkParameters();
        if (!(this.m_CECClient == null || this.m_managedSystem == null && this.m_managedSystem.trim().length() <= 0 || (n = (pICECDataBean = this.m_CECClient.getCECDataBean(new String[]{"state"})).getCecState().intValue()) != 254 && n != 241 && n != 242 && n != 250)) {
            String[] stringArray = new String[]{pICECDataBean.getCECStateString()};
            throw new PIHscClientException("8000", "HSCCIMExceptionBundle", "0237", stringArray, null);
        }
        this.doGetDump();
    }

    private void checkParameters() throws PIHscClientException {
        String string = "";
        if (this.m_dumpType == null || !TYPE_SYSTEM.equals(this.m_dumpType) && !TYPE_FSP.equals(this.m_dumpType) && !TYPE_SMA.equals(this.m_dumpType) && !TYPE_POWER_SUBSYSTEM.equals(this.m_dumpType)) {
            string = string + ", -t";
        }
        if (this.m_frame != null && (this.m_side == null || !"a".equals(this.m_side.toLowerCase()) && !"b".equals(this.m_side.toLowerCase()))) {
            string = string + ", -s";
        }
        if (string.length() > 0) {
            if (string.startsWith(", ")) {
                string = string.substring(2, string.length());
            }
            String[] stringArray = new String[]{string};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "REQUIRED_PARMS_ERROR", stringArray, null);
        }
        if (this.m_managedSystem != null && this.m_side != null) {
            string = "-s";
        }
        if (this.m_frame != null && !TYPE_POWER_SUBSYSTEM.equals(this.m_dumpType)) {
            string = "-e";
        }
        if (this.m_managedSystem != null && TYPE_POWER_SUBSYSTEM.equals(this.m_dumpType)) {
            string = "-m";
        }
        if (string.length() > 0) {
            String[] stringArray = new String[]{string};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_PARM_COMBINATION", stringArray, null);
        }
    }

    private void mapParameters(HashMap hashMap) {
        this.m_managedSystem = (String)hashMap.get("-m");
        this.m_dumpType = (String)hashMap.get("-t");
        this.m_frame = (String)hashMap.get("-e");
        this.m_side = (String)hashMap.get("-s");
    }

    public static void printHelp(PrintStream printStream, boolean bl) {
        if (bl) {
            printStream.print('\u0000');
            bl = false;
        }
        printStream.println(HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "GETDUMP_HELP_GA3"));
    }

    public static int callCommandFromRouter(PIHSCFrameClient pIHSCFrameClient, PIHSCCECClient pIHSCCECClient, String[] stringArray, PrintStream printStream, boolean bl) {
        int n = 0;
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        PIDumpCommand pIDumpCommand = new PIDumpCommand(pIHSCFrameClient, pIHSCCECClient, printStream, bl);
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(stringArray[i]);
            }
            HashMap hashMap = PIHMCCommandUtils.parseParameters(arrayList, pIDumpCommand.m_validParms);
            pIDumpCommand.mapParameters(hashMap);
            pIDumpCommand.performCommand();
        }
        catch (PIHscClientException pIHscClientException) {
            if (bl) {
                printStream.print('\u0001');
                bl = false;
            }
            pIHscClientException.printStackTrace(System.out);
            if ("8000".equals(pIHscClientException.getHscExId())) {
                printStream.println(pIHscClientException.getMessage());
            } else {
                String string = pIHscClientException.getMessage();
                if (string == null || string.length() == 0) {
                    string = HSCResourceBundleUtil.getMessage("HSCExceptionBundle", "8016");
                }
                printStream.println(string);
            }
            n = 1;
        }
        catch (Exception exception) {
            if (bl) {
                printStream.print('\u0001');
                bl = false;
            }
            exception.printStackTrace(System.out);
            String string = HSCResourceBundleUtil.getMessage("HSCExceptionBundle", "8016");
            printStream.println(string);
            n = 1;
        }
        return n;
    }
}

